dnl Copyright 2004, Sven Trenkel (Trenkel@Semidefinite.de), Martin Gollub (LuckyLuciano@gmx.de)
dnl
dnl    This file is part of RTS.
dnl
dnl    RTS is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    RTS is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with RTS; if not, write to the Free Software
dnl    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


dnl Makro fr den EMIT Befehl

define([Emit], [

dnl Unterscheiden zwischen Protoprozessen und einer normalen Task

 ifdef([RTS_ActiveTask], [
  define([RTS_Temp], RTS_ResourceClaim_[]RTS_ActiveTask)
  pushdef(RTS_ResourceClaim_[]RTS_ActiveTask, RTS_Temp)
 ], [
  define([RTS_Temp], [RTS_MainClaim])
  pushdef([RTS_MainClaim], RTS_MainClaim)
 ])

dnl berprfen, ob das zu emitierende signal in der CLAIM Anweisung stand

 ifelse(IsIn($1, RTS_Temp), 0, [
  RTS_Error([$1 in Emit ohne Claim])
 ], [

dnl Den aktuellen CLAIM auf den Stack sichern und
dnl alle Resourcen bis zur benutzten entfernen

  ifdef([RTS_ActiveTask], [
   define(RTS_ResourceClaim_[]RTS_ActiveTask, RTS_RemoveItemTo($1, RTS_Temp))
  ], [
   define([RTS_MainClaim], RTS_RemoveItemTo($1, RTS_Temp))
  ])
  pushdef([RTS_CurrentBlock], [Emitblock])
  pushdef([RTS_ToEmit], $1)

dnl PEARL Code zum Belegen der Semas
dnl Je nach WAIT entweder blockierend oder nicht

  IF RTS_Wait[]RTS_TryLevel == 0 THEN
   IF NOT(TRY(EmitSema_$1)) THEN
    Throw(EXCEPTION_SignalInUse);
   FIN;
  ELSE
   REQUEST EmitSema_$1;
  FIN
 ])
])


dnl EMEND - Freigeben der Sema

define([EmEnd], [
 RTS_EndBlock([Emitblock], [EmEnd])

dnl Den auf den Stack gesicherten CLAIM wiederherstellen

 ifdef([RTS_ActiveTask], [
  popdef(RTS_ResourceClaim_[]RTS_ActiveTask)
 ], [
  popdef([RTS_MainClaim])
 ])

dnl PEARL Code zum Freigeben der Sema

 RELEASE [ResourceSema_]RTS_ToEmit
 popdef([RTS_ToEmit])
])
