dnl Copyright 2004, Sven Trenkel (Trenkel@Semidefinite.de), Martin Gollub (LuckyLuciano@gmx.de)
dnl
dnl    This file is part of RTS.
dnl
dnl    RTS is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    RTS is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with RTS; if not, write to the Free Software
dnl    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


changequote([, ])
changecom(/*, */)


dnl Makro RTS_Error
dnl gibt eine Fehlermeldung aus und beendet M4

define([RTS_Error],[errprint([Fehler in ]__file__[:]__line__[: $*
])m4exit])


dnl berprfen, ob der aktuell geschlossene Block mit dem zuletzt geffneten bereinstimmt
dnl Im Fehlerfall eine Fehlermeldung ausgeben und M4 beenden

define([RTS_EndBlock], [
 ifelse(RTS_CurrentBlock, $1, [
  popdef([RTS_CurrentBlock])
 ], [
  RTS_Error([$2 innerhalb eines nicht abgeschlossenen ]RTS_CurrentBlock[es])
 ])
])


dnl Nach dem Ende der Datei ausfren: berprfen, ob alle Blcke geschlossen wurden

m4wrap([ifdef([RTS_CurrentBlock], [RTS_Error([Nicht abgeschlossener ]RTS_CurrentBlock)])])


dnl Weitere Makrodefinitionen

include(RTS_Exceptions.ph)
include(RTS_Tasks.ph)
include(RTS_Emit.ph)
include(RTS_Resources.ph)
