dnl Copyright 2004, Sven Trenkel (Trenkel@Semidefinite.de), Martin Gollub (LuckyLuciano@gmx.de)
dnl
dnl    This file is part of RTS.
dnl
dnl    RTS is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    RTS is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with RTS; if not, write to the Free Software
dnl    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


dnl Jedes Programm wird zweimal von M4 bearbeitet
dnl Hier wird der zweite Durchlauf vorbereitet

define(*[RTS_StackSize]*, 4096)
define(*[RTS_ParallelBlocks]*, 0)
syscmd(*[echo "changecom(/*, */)" > temp]*)
syscmd(*[echo "changequote(*[, ]*)" >> temp]*)
m4wrap(*[
 syscmd(echo "*[define]*(*[RTS_ParallelBlocks]*, RTS_ParallelBlocks)" >> temp)
]*)
m4wrap(*[
 RTS_CheckLoneExec
]*)
*[include(temp)]*


dnl C Code: Semas zur PAREND Synchronisation anlegen

uint RTS_TaskSema[*[RTS_ParallelBlocks]*];
uint RTS_TaskReleaseSema[*[RTS_ParallelBlocks]*];


dnl Das TASK Makro
dnl Der Resource CLAIM wird als leere Menge initialisiert,
dnl falls der Task keinen CLAIM hat

define(*[Task]*, *[
 ifdef(*[RTS_ActiveTask]*, *[
  RTS_Error(*[Task $1 wurde innerhalb von Task ]*RTS_ActiveTask*[ definiert]*)
 ]*)
 define(*[RTS_ActiveTask]*, $1) void _FAR _FIXED $1(void) {
 define(*[RTS_TaskInLine_]*__line__, $1)
 define(*[RTS_ResourceClaim_]*$1, {})
 do
]*)


dnl Das CLAIM Makro

define(*[Claim]*, *[
 ifdef(*[RTS_TaskInLine_]*__line__, *[

dnl CLAIM Liste fr den aktuellen Protoprozess abspeichern

  define(*[RTS_temp]*, *[RTS_TaskInLine_]*__line__)
  define(*[RTS_ResourceClaim_]*RTS_temp, BuildList($@))

dnl Wenn eine Resource mehrfach vorkommt, Fehlermeldung ausgeben

  ifelse(DubInList(BuildList($@)), 1, *[
   RTS_Error(*[Der Claim von ]*RTS_ActiveTask*[ enthlt eine Resource mehrfach]*)
  ]*)
 ]*, *[
  ifelse(RTS_MAINinLine, __line__, *[

dnl CLAIM Liste fr die aktuelle Task abspeichern

   define(*[RTS_MainClaim]*, BuildList($@))

dnl Wenn eine Resource mehrfach vorkommt, Fehlermeldung ausgeben

   ifelse(DubInList(RTS_MainClaim), 1, *[
    RTS_Error(*[Der Main Claim enthlt eine Resource mehrfach]*)
   ]*)
  ]*, *[

dnl Die CLAIM Anweisung stand ohne TASK Anweisung einzeln im Programmcode

   RTS_Error(*[Claim ohne Task]*)
  ]*)
 ]*)
]*)


dnl Das TASKEND Makro zeigt das Ende eines Protoprozesses an

define(*[TaskEnd]*, *[
 while(0);

dnl C Code zum Freigeben der PAREND Synchronisations Sema

 RmGetBinSemaphore(RM_WAIT, RTS_TaskReleaseSema[*[RTS_]*RTS_ActiveTask*[ExecutesFrom]*]);
 RmReleaseBinSemaphore(RTS_TaskSema[*[RTS_]*RTS_ActiveTask*[ExecutesFrom]*]);
 RmDeleteTask(RM_OWN_TASK);
 undefine(*[RTS_ActiveTask]*)
 }
]*)


dnl Das PARALLEL Makro
dnl Der Zhler fr PARALLEL Blcke wird um eins erhht,
dnl damit die absolute Zahl der Blcke im zweiten Durchlauf bekannt ist

define(*[Parallel]*, *[
 do {
  int RTS_i;
  uint RTS_TaskId;
  pushdef(*[RTS_CurrentBlock]*, *[Parallelblock]*)
  define(*[RTS_ParallelBlocks]*, incr(RTS_ParallelBlocks))
  pushdef(*[RTS_Executes]*, 0)
  do 
]*)


dnl Dies ist ein internes Hilfsmakro
dnl Es berprft, ob der Protoprozess mit den selben Resourcen aufgerufen wurde,
dnl die in seiner CLAIM Anweisung standen.

define(*[RTS_CheckLoneExec]*, *[
 ifdef(*[RTS_LastExecute]*, *[
  define(*[RTS_Temp]*, RTS_ResourceClaim_*[]*RTS_LastExecute)
  ifelse(RTS_Temp, {}, , *[
   RTS_Error(*[Execute ]*RTS_LastExecute*[ ohne With, trotz Claim Liste]*)
  ]*)
 ]*)
]*)


dnl Das EXECUTE Makro

define(*[Execute]*, *[

dnl Falls es auerhalb eines PARALLEL Blockes steht,
dnl wird eine Fehlermeldung ausgegeben

 ifelse(RTS_CurrentBlock, *[Parallelblock]*, , *[
  RTS_Error(*[Execute nicht unmittelbar innerhalb eines Parallelblockes]*)
 ]*)

dnl Der EXECUTE Zhler dieses Blockes wird erhht

 define(*[RTS_Executes]*, incr(RTS_Executes))
 m4wrap(*[syscmd(echo "*[define]*(*[RTS_]*$1*[ExecutesFrom]*, eval( RTS_ParallelBlocks-1))" >> temp)]*)

dnl C Code zum Starten der Task

 RmCreateChildTask(0, RTS_StackSize, ifelse($2, , 100, $2), $1, &RTS_TaskId);
 RmStartTask(RM_NO_WAIT, RTS_TaskId, ifelse($2, , 100, $2), 0, 0)
 RTS_CheckLoneExec
 define(*[RTS_LastExecuteLine]*, __line__)
 define(*[RTS_LastExecute]*, $1)
]*)


dnl Das WITH Makro

define(*[With]*, *[

dnl Falls WITH ohne EXECUTE steht,
dnl wird eine Fehlermeldung ausgegeben

 ifelse(__line__, RTS_LastExecuteLine, , *[
  RTS_Error(*[With ohne Execute]*)
 ]*)
 define(*[RTS_Temp]*, RTS_ResourceClaim_*[]*RTS_LastExecute)
 ifelse(BuildList($@), RTS_Temp,, *[
  RTS_Error(RTS_LastExecute*[: Falsche Resourcenliste]*)
 ]*)
 ifdef(*[RTS_ActiveTask]*, *[
  define(*[RTS_Temp]*, RTS_ResourceClaim_*[]*RTS_ActiveTask)
  *[dnl]* RTS_RemoveListTo(RTS_Temp, $@)
 ]*, *[
  *[dnl]* RTS_RemoveListTo(RTS_MainClaim, $@)
 ]*)
 undefine(*[RTS_LastExecute]*)
]*)


dnl Das PAREND Makro

define(*[ParEnd]*, *[
 RTS_EndBlock(*[Parallelblock]*, *[ParEnd]*)
 while (0);

dnl C Code
dnl Die PAREND Sema wird fr jedes EXECUTE in diesem
dnl Block einmal angefordert

 for(RTS_i = 0; RTS_i < RTS_Executes; ++RTS_i) {
  RmGetBinSemaphore(RM_WAIT, RTS_TaskSema[eval( RTS_ParallelBlocks-1)]);
  RmReleaseBinSemaphore(RTS_TaskReleaseSema[eval( RTS_ParallelBlocks-1)]);
 }} while(0)
]*)
