dnl Copyright 2004, Sven Trenkel (Trenkel@Semidefinite.de), Martin Gollub (LuckyLuciano@gmx.de)
dnl
dnl    This file is part of RTS.
dnl
dnl    RTS is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    RTS is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with RTS; if not, write to the Free Software
dnl    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


dnl Die Makros fr Ressourcen

define(*[RTS_TotalDemand]*, {})
define(*[RTS_CurrentDemand]*, {})
define(*[RTS_MainClaim]*, {})
define(*[RTS_ResourceList]*, {})


dnl SIGNAL Makro
dnl Legt die beiden bentigten Semas an

define(*[Signal]*,*[
 define(Type_Signal_$1)
 define(*[RTS_ResourceList]*, Cons($1, RTS_ResourceList))
 uint ResourceSema_$1, EmitSema_$1
]*)


dnl EXCLUSIVE Makros
dnl Legt eine Sema an und verknpft mit dem Namen
dnl der echten Ressource

define(*[Exclusive]*,*[
 define(Type_Exclusive_$1)
 define(*[RTS_ResourceList]*, Cons($1, RTS_ResourceList))
 define(RTS_Realname_$1,*[*[$2]*]*)
 define(*[$2]*, *[RTS_Error(*[$2 wurde auerhalb eines Demand Blockes benutzt]*)]*)
 uint ResourceSema_$1
]*)


dnl Ein internes Hilfsmakro, da fr jede Ressource
dnl eines DEMAND Aufrufs einmal ausgefhrt wird

define(*[RTS_HilfsDemand]*, *[
 ifelse($2, , *[
  pushdef(*[RTS_CurrentDemand]*, $1)
 ]*, *[
  ifdef(*[RTS_ActiveTask]*, *[
   define(*[RTS_Temp]*, RTS_ResourceClaim_*[]*RTS_ActiveTask)
  ]*, *[
   define(*[RTS_Temp]*, *[RTS_MainClaim]*)
  ]*)
  ifelse(IsIn($2, RTS_Temp), 1, *[
   ifdef(*[RTS_ActiveTask]*, *[
    define(RTS_ResourceClaim_*[]*RTS_ActiveTask, RTS_RemoveItemTo($2, RTS_Temp))
   ]*, *[
    define(*[RTS_MainClaim]*, RTS_RemoveItemTo($2, RTS_Temp))
   ]*)

dnl PEARL Code zum Abfragen der Resourcen Semas,
dnl je nach WAIT Status blockierend oder nicht

   if(RTS_Wait== 0) {
    if (RmGetBinSemaphore(RM_CONTINUE, ResourceSema_$2) != RM_OK) {

dnl Eine Ressource konnte nicht belegt werden
dnl Alle bislang belegten Ressourcen wieder freigeben
dnl und eine Exception auslsen

     RTS_Freigabe($1)
     Throw(EXCEPTION_ResourceInUse);
    } 
   } else {
    RmGetBinSemaphore(RM_WAIT, ResourceSema_$2);
   }
   define(*[RTS_TotalDemand]*, Cons($2, RTS_TotalDemand))
   undefine(RTS_Realname_$2)

dnl Rekursiver Aufruf dieses Makros

   RTS_HilfsDemand(Cons($2, $1), shift(shift($@)))
  ]*, *[

dnl Fehlermeldung, falls die anzufordernde Ressource nicht
dnl in der CLAIM Anweisung stand

   RTS_Error(*[$2 im Demand ohne Claim]*)
  ]*)
 ]*)
]*)


dnl Das DEMAND Makro

define(*[Demand]*, *[
 define(*[RTS_Temp]*, RTS_ResourceClaim_*[]*RTS_ActiveTask)
 ifdef(*[RTS_ActiveTask]*, *[
  pushdef(RTS_ResourceClaim_*[]*RTS_ActiveTask, RTS_Temp)
 ]*, *[
  pushdef(*[RTS_MainClaim]*, RTS_MainClaim)
 ]*)

dnl Der Hilfsmakro aufrufen

 RTS_HilfsDemand({}, $@)
 pushdef(*[RTS_CurrentBlock]*, *[Demandblock]*)
]*)


dnl Internes Hilfsmakro
dnl Es gibt alle von einem DAMAND Makro bisher belegten Semas wieder frei
dnl fr den Fall, da DEMAND eine Exception auslsen mu

define(*[RTS_Freigabe]*, *[
 ifelse($1, {}, , *[
  RmReleaseBinSemaphore(ResourceSema_*[]*Head($1));
  RTS_Freigabe(Tail($1))
 ]*)
]*)


dnl Internes Hilfsmakro
dnl Wird von FREE fr jede belegte Ressource aufgerufen

define(*[RTS_FreeHilf]*, *[
 ifelse($1, {}, , *[
  RTS_FreeHilf(Tail($1))

dnl Je nach Ressourcentyp eine andere Sema freigeben

  ifdef(Type_Signal_*[]*Head($1), *[
   RmReleaseBinSemaphore(EmitSema_*[]*Head($1));
  ]*)
  ifdef(Type_Exclusive_*[]*Head($1), *[
   RmReleaseBinSemaphore(ResourceSema_*[]*Head($1));
  ]*)
  define(*[RTS_TotalDemand]*, RTS_RemoveItem(Head($1), RTS_TotalDemand))
  define(*[RTS_Temp]*, RTS_Realname_[]Head($1))
  define(RTS_Temp, *[RTS_Error(*[Resource wurde auerhalb ihres Demand Blockes benutzt]*)]*)
 ]*)
]*)


dnl Das FREE Makro

define(*[Free]*, *[

dnl Fehlermeldung ausgeben, wenn es kein zugehriges DEMAND gab

 ifelse(RTS_CurrentBlock, *[Demandblock]*, , *[
  RTS_Error(*[Free ohne zugehriges Demand]*)
 ]*)
 popdef(*[RTS_CurrentBlock]*)

dnl Das Hilfsmakro aufrufen

 RTS_FreeHilf(RTS_CurrentDemand)
 popdef(*[RTS_CurrentDemand]*)
 ifdef(*[RTS_ActiveTask]*, *[popdef(RTS_ResourceClaim_*[]*RTS_ActiveTask)]*, *[popdef(*[RTS_MainClaim]*)]*)
]*)

define(*[RTS_MainHilf]*, *[
 ifelse($1, {}, , *[
  ifdef(Type_Signal_*[]*Head($1),*[
   RmCreateBinSemaphore(0, &ResourceSema_*[]*Head($1));
   RmCreateBinSemaphore(0, &EmitSema_*[]*Head($1));
   RmGetBinSemaphore(RM_WAIT, ResourceSema_*[]*Head($1));
  ]*)
  ifdef(Type_Exclusive_*[]*Head($1), *[
   RmCreateBinSemaphore(0, &ResourceSema_*[]*Head($1));
  ]*)
  RTS_MainHilf(Tail($1))
 ]*)
]*)


define(*[main]*, *[*[main]*($@) {
 define(*[RTS_MAINinLine]*, __line__)
 int RTS_i;
 RTS_MainHilf(RTS_ResourceList)
 for (RTS_i = 0; RTS_i < *[RTS_ParallelBlocks]*; ++RTS_i) {
  RmCreateBinSemaphore(0, &RTS_TaskSema[RTS_i]);
  RmGetBinSemaphore(RM_WAIT, RTS_TaskSema[RTS_i]);
  RmCreateBinSemaphore(0, &RTS_TaskReleaseSema[RTS_i]);
 }
 do 
]*)

define(*[RTS_EndMainHilf]*, *[
 ifelse($1, {}, , *[
  ifdef(Type_Signal_*[]*Head($1), *[
   RmDeleteBinSemaphore(ResourceSema_*[]*Head($1));
   RmDeleteBinSemaphore(EmitSema_*[]*Head($1));
  ]*)
  ifdef(Type_Exclusive_*[]*Head($1), *[
   RmDeleteBinSemaphore(ResourceSema_*[]*Head($1));
  ]*)
  RTS_EndMainHilf(Tail($1))
 ]*)
]*)

define(*[endmain]*, *[ while(0);
 RTS_EndMainHilf(RTS_ResourceList)
 for (RTS_i = 0; RTS_i < *[RTS_ParallelBlocks]*; ++RTS_i) {
  RmDeleteBinSemaphore(RTS_TaskSema[RTS_i]);
  RmDeleteBinSemaphore(RTS_TaskReleaseSema[RTS_i]);
 }
 return 0;
}
]*)


dnl Zwei interne Hilfsmakros
dnl Sie berprfen, ob ein Item in einer Liste vorkommt
dnl und ob in einer Liste Items doppelt vorhanden sind

define(*[IsIn]*, *[ifelse($2, {}, 0, *[ifelse($1, Head($2), 1, *[IsIn($1, Tail($2))]*)]*)]*)
define(*[DubInList]*, *[ifelse($1, {}, 0, *[ifelse(IsIn(Head($1), Tail($1)), 1, 1, *[DubInList(Tail($1))]*)]*)]*)
