dnl Copyright 2004, Sven Trenkel (Trenkel@Semidefinite.de), Martin Gollub (LuckyLuciano@gmx.de)
dnl
dnl    This file is part of RTS.
dnl
dnl    RTS is free software; you can redistribute it and/or modify
dnl    it under the terms of the GNU General Public License as published by
dnl    the Free Software Foundation; either version 2 of the License, or
dnl    (at your option) any later version.
dnl
dnl    RTS is distributed in the hope that it will be useful,
dnl    but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl    GNU General Public License for more details.
dnl
dnl    You should have received a copy of the GNU General Public License
dnl    along with RTS; if not, write to the Free Software
dnl    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


dnl Exception Definitionen

define(*[EXCEPTION_SignalInUse]*, 1)
define(*[EXCEPTION_ResourceInUse]*, 2)
define(*[EXCEPTION_SignalNotSent]*, 3)

define(*[RTS_Trys]*, 0)


dnl Das TRY Makro
dnl Setzt eine Sprungmarke und initialisiert
dnl bentigte lokale Variablen

define(*[Try]*, *[
 define(*[RTS_Trys]*, incr(RTS_Trys))
 pushdef(*[RTS_CurrentBlock]*, *[Tryblock]*)
 pushdef(*[RTS_TryLevel]*, RTS_Trys)
 pushdef(*[RTS_Throws]*,0)
 pushdef(*[RTS_CanThrow]*, {})
 do {
 int RTS_ContinueAt = 0, RTS_ThrownException = 0, RTS_Wait = 0;
 *[RTS_TryLabel]*RTS_Trys*[:]*
 switch (RTS_ThrownException) { case 0:
]*)


dnl Das THROW Makro
dnl Wird benutzt, um eine Exception auszulsen

define(*[Throw]*, *[
 ifdef(*[RTS_TryLevel]*, , *[RTS_Error(*[Throw auerhalb eines Try Blockes]*)]*)
 define(*[RTS_Throws]*, incr(RTS_Throws))
 define(*[RTS_CanThrow]*, Cons($1, RTS_CanThrow))
 RTS_ContinueAt = RTS_Throws;
 RTS_ThrownException = $1;

dnl Sprung zum Exceptionhandler

 goto *[RTS_TryLabel]*RTS_Trys*[;]*
 *[RTS_ThrowLabel]*RTS_Trys*[_]*RTS_Throws*[:]*
]*)

define(*[RTS_HilfsExceptions]*, *[ifelse($1, , , *[case $1: 
RTS_HilfsExceptions(shift($@))]*)]*)


dnl Das EXCEPTIONS Makro

define(*[Exceptions]*, *[

dnl Fehlermeldung ausgeben, falls es auerhalb eines TRY Blocks steht

 ifelse(RTS_CurrentBlock, *[Tryblock]*, , *[
  RTS_Error(*[Except innerhalb eines nicht abgeschlossenen ]*RTS_CurrentBlock*[es]*)
 ]*)
 break;
 RTS_HilfsExceptions($@)
 define(*[RTS_CanThrow]*, RTS_RemoveList(RTS_CanThrow, $*))
]*)


dnl Das EXEND Makro

define(*[ExEnd]*, *[
 RTS_EndBlock(*[Tryblock]*, *[ExEnd]*)

dnl Fehlermeldung ausgeben, falls mglicherweise
dnl auftretende Exceptions 

 ifelse(RTS_CanThrow, {}, , *[
  RTS_Error(*[Der Try Block enthlt unverarbeitete Exceptions]*)
 ]*)
 popdef(*[RTS_TryLevel]*)
 popdef(*[RTS_Throws]*)
 popdef(*[RTS_CanThrow]*)
 break;
 }
}while(0)
]*)


dnl Hilfsmakro fr CONTINUE

define(*[RTS_ContinueLoop]*, *[
 ifelse(RTS_i, 0, , *[
  if(RTS_ContinueAt == RTS_i) {
  goto *[RTS_ThrowLabel]*RTS_TryLevel*[_]*RTS_i*[;]*
  }
  define(*[RTS_i]*, decr(RTS_i))
  RTS_ContinueLoop
 ]*)
]*)


dnl Das CONTINUE Makro

define(*[Continue]*, *[
 define(*[RTS_i]*, RTS_Throws)
 RTS_Wait = 0;
 RTS_ContinueLoop
]*)


dnl Das WAIT Makro

define(*[Wait]*, *[
 RTS_Wait = 1;
 RTS_ContinueAt = 0;
 RTS_ThrownException = 0;
 goto *[RTS_TryLabel]*RTS_TryLevel
]*)


dnl Das REPEAT Makro
dnl Anders als WAIT wird die lokale Variable
dnl fr Warten auf 0 gesetzt

define(*[Repeat]*, *[
 RTS_Wait = 0;
 RTS_ContinueAt = 0;
 RTS_ThrownException = 0;
 goto *[RTS_TryLabel]*RTS_TryLevel
]*)


dnl Das ABORT Makro springt zum Blockende

define(*[Abort]*, *[
 goto RTS_ExEndLabel_*[]*RTS_TryLevel
]*)


dnl Hilfsmakros fr den Umgang mit Listen

define(*[BuildListHilf]*, *[ifelse($2, , $1, *[BuildListHilf(Cons($2, $1), shift(shift($@)))]*)]*)
define(*[BuildList]*, *[BuildListHilf({}, $@)]*)
define(*[Cons]*,*[ifelse($2,{},{$1},substr($2,0,decr(len($2)));$1})]*)
define(*[HeadEnd]*, *[ifelse($1, , -1, substr($1, 0, 1), ;, 0, *[incr(HeadEnd(substr($1, 1)))]*)]*)
define(*[Head]*, *[substr($1, 1, decr(HeadEnd($1)))]*)
define(*[Tail]*,*[{substr($1, incr(HeadEnd($1)), eval(len($1) - HeadEnd($1) - 2))}]*)
define(*[RTS_RemoveList]*, *[ifelse($2, , $1, *[RTS_RemoveList(RTS_RemoveItem($2, $1), shift(shift($@)))]*)]*)
define(*[RTS_RemoveListTo]*, *[ifelse($2, , $1, *[RTS_RemoveListTo(RTS_RemoveItemTo($2, $1), shift(shift($@)))]*)]*)
define(*[RTS_RemoveItemTo]*, *[ifelse($2, {}, *[RTS_Error(*[A!]*)]*, Head($2), $1, *[Tail($2)]*, *[RTS_RemoveItemTo($1, Tail($2))]*)]*)
define(*[RTS_RemoveItem]*, *[RTS_RemoveItemAux($1, $2, {})]*)
define(*[RTS_RemoveItemAux]*, *[ifelse($2, {}, $3, *[ifelse($1, Head($2), RTS_RemoveItemAux($1, Tail($2), $3), RTS_RemoveItemAux($1, Tail($2), Cons(Head($2), $3)))]*)]*)
