package gui;

import java.io.File;
import java.io.FileReader;
import javax.swing.JOptionPane;

/**
 * This class provides static methods to realise the input and output operations
 * of the programming sources. 
 * 
 * @author Christina K. Houben
 */
public class StyledFileReader {
	
	/** Reads an input file as plain text. */
	public static String readTextFile(File file) {
		// input exception handling
		if (! file.exists()) {
			JOptionPane.showMessageDialog(
					null,
					"The file " + file.getName() + " does not exist!",
					"Input File Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
		if (! file.canRead()) {
			JOptionPane.showMessageDialog(
					null,
					"The file " + file.getName() + " is not readable!",
					"Input File Error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
		// read input file
		StringBuffer buffer = new StringBuffer();
		try {
			FileReader reader = new FileReader(file);
			int c;
			while ((c = reader.read()) != -1) {
				buffer.append((char) c);
			}
			reader.close();
		}
		catch (Exception x) {
			JOptionPane.showMessageDialog(
					null,
					"Error while reading " + file.getName() + "!",
					"Input File Error",
					JOptionPane.ERROR_MESSAGE);
		}
		return buffer.toString();
	}

}
