package anaysis;

/**
 * This class represents a unit system. A unit system contains dimensions,
 * units, relationships between units and prefixes. A dimension is a measurable
 * characteristic of a real object, e.g. length or electric current. There are
 * also various dimension-less characteristics, e.g. amount measured in 1 and
 * dozen measured in 12. A physical unit relates to a concrete scale to measure,
 * e.g. metres for a length or feet for a length. One dimension can be related
 * with several units. Both dimensions and units have symbols. The symbol of
 * length is l and the symbol of metres is m. A unit is composed of a prefix, a
 * unit symbol and an exponent. Derived dimensions resp. units originate from
 * basic dimensions resp. units by multiplication and division.
 * 
 * We restrict unit systems to the following properties: no implicit conversion
 * between physical units of the same dimension, no direct support for unit
 * conversion, only integer exponents.
 * 
 * @author Christine K. Houben
 */
public class UnitSystem {
	
	public UnitSystem(String sourceXML) {
		
	}

}
